# Web Hosting Deployment Seçenekleri

## Seçenek 1: Docker Destekli Hosting (VPS/Dedicated Server)

### Gereksinimler:
- Docker ve Docker Compose kurulu sunucu
- SSH erişimi
- Root veya sudo yetkisi

### Deployment Adımları:
1. Dosyaları sunucuya yükleyin
2. `.env.production`'ı `.env` olarak kopyalayın
3. Şifreleri ve domain güncelleyin
4. `docker-compose -f docker-compose.prod.yml up -d --build`

✅ **Bu durumda direkt çalışacaktır!**

---

## Seçenek 2: Geleneksel Shared Hosting (Docker YOK)

Çoğu shared hosting Docker desteklemez. Bu durumda alternatif yöntemler:

### A) Laravel'i Normal PHP Hosting'e Deploy Etmek

**Gereksinimler:**
- PHP 8.2+ 
- MySQL/MariaDB
- Composer erişimi

**Adımlar:**
1. `composer install --no-dev --optimize-autoloader`
2. `npm run build` 
3. Dosyaları FTP ile yükle
4. .env dosyasını ayarla
5. `php artisan migrate --force`

### B) Shared Hosting İçin Deployment (Docker YOK)

**Hazırlanan Dosyalar:**
- `.env.shared-hosting` - Shared hosting için özel env dosyası
- `public/.htaccess` - Zaten mevcut ve uygun

**Adımlar:**

1. **Dosyaları Hazırlayın:**
   ```bash
   composer install --no-dev --optimize-autoloader
   npm run build
   ```

2. **Environment Dosyasını Ayarlayın:**
   ```bash
   cp .env.shared-hosting .env
   ```
   
   Sonra .env dosyasında şunları güncelleyin:
   - `APP_URL=https://your-domain.com` → Gerçek domain
   - `DB_DATABASE=your_cpanel_database_name` → cPanel'den aldığınız DB adı
   - `DB_USERNAME=your_cpanel_db_user` → cPanel DB kullanıcısı
   - `DB_PASSWORD=your_cpanel_db_password` → cPanel DB şifresi

3. **Dosyaları FTP ile Yükleyin:**
   - Tüm dosyaları `public_html` klasörüne yükleyin
   - VEYA Laravel root'u `public_html` dışına, sadece `public` klasörünü `public_html`'ye

4. **cPanel'de Veritabanı Oluşturun:**
   - MySQL Database bölümünden yeni database oluşturun
   - Kullanıcı oluşturun ve database'e yetkiler verin
   - Bu bilgileri `.env` dosyasında güncelleyin

5. **Migration'ları Çalıştırın:**
   - cPanel Terminal'den: `php artisan migrate --force`
   - Veya phpMyAdmin'den SQL dosyasını import edin

6. **Dosya İzinlerini Ayarlayın:**
   ```bash
   chmod -R 755 storage/
   chmod -R 755 bootstrap/cache/
   ```

**✅ Bu durumda da direkt çalışacaktır!**

### Hosting Türü Nasıl Anlaşılır?

**Docker Destekli (VPS/Dedicated):**
- SSH erişimi var
- `docker --version` komutu çalışıyor
- Root/sudo yetkisi var

**Shared Hosting:**
- Sadece FTP/cPanel erişimi var
- PHP/MySQL/phpMyAdmin mevcut
- SSH sınırlı veya yok

### Hangi Seçenek Size Uygun?

- **VPS/Dedicated Server varsa** → Docker kullanın (daha profesyonel)
- **Shared hosting varsa** → Geleneksel yöntem (daha yaygın)

Her iki durumda da projeniz çalışacaktır!
