<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $sliders = [
            [
                'title' => 'Sevdiklerinize En Güzel Çiçekleri Gönderin',
                'description' => 'Taze çiçekler, özel buketler ve hızlı teslimat ile sevdiklerinizi mutlu edin.',
                'button_text' => 'Çiçekleri Keşfet',
                'button_link' => '/products',
                'background_color' => '#E91E63',
                'text_color' => '#FFFFFF',
                'sort_order' => 1,
            ],
            [
                'title' => 'Özel Günleriniz İçin Buketler',
                'description' => 'Doğum günü, yıldönümü, sevgililer günü için özel tasarım buketler.',
                'button_text' => 'Buketleri İncele',
                'button_link' => '/categories/buketler',
                'background_color' => '#4CAF50',
                'text_color' => '#FFFFFF',
                'sort_order' => 2,
            ],
            [
                'title' => 'Ücretsiz Teslimat',
                'description' => '200₺ ve üzeri alışverişlerde ücretsiz teslimat fırsatı!',
                'button_text' => 'Hemen Sipariş Ver',
                'button_link' => '/products',
                'background_color' => '#FF9800',
                'text_color' => '#FFFFFF',
                'sort_order' => 3,
            ],
        ];

        foreach ($sliders as $slider) {
            \App\Models\Slider::create($slider);
        }
    }
}
