<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = \App\Models\Category::all();

        $products = [
            // Güller kategorisi
            [
                'name' => 'Kırmızı Gül Buketi',
                'slug' => 'kirmizi-gul-buketi',
                'description' => '12 adet taze kırmızı gül, özel ambalaj ile. Sevgililer günü ve özel günler için ideal.',
                'short_description' => '12 adet kırmızı gül, özel ambalaj',
                'price' => 150.00,
                'sale_price' => 120.00,
                'stock_quantity' => 50,
                'sku' => 'RRB-001',
                'is_featured' => true,
                'category_id' => $categories->where('slug', 'guller')->first()->id,
                'delivery_days' => 1,
                'care_instructions' => 'Serin yerde tutun, günde bir kez su değiştirin.',
            ],
            [
                'name' => 'Beyaz Gül Buketi',
                'slug' => 'beyaz-gul-buketi',
                'description' => '15 adet beyaz gül, şık ambalaj. Nikah, nişan ve özel günler için.',
                'short_description' => '15 adet beyaz gül',
                'price' => 180.00,
                'stock_quantity' => 30,
                'sku' => 'WRB-001',
                'category_id' => $categories->where('slug', 'guller')->first()->id,
                'delivery_days' => 1,
            ],
            [
                'name' => 'Pembe Gül Buketi',
                'slug' => 'pembe-gul-buketi',
                'description' => '10 adet pembe gül, romantik ambalaj.',
                'short_description' => '10 adet pembe gül',
                'price' => 130.00,
                'sale_price' => 110.00,
                'stock_quantity' => 40,
                'sku' => 'PRB-001',
                'is_featured' => true,
                'category_id' => $categories->where('slug', 'guller')->first()->id,
                'delivery_days' => 1,
            ],

            // Orkideler kategorisi
            [
                'name' => 'Beyaz Orkide',
                'slug' => 'beyaz-orkide',
                'description' => 'Zarif beyaz orkide, saksıda. Ev ve ofis dekorasyonu için mükemmel.',
                'short_description' => 'Saksıda beyaz orkide',
                'price' => 200.00,
                'stock_quantity' => 25,
                'sku' => 'WOR-001',
                'category_id' => $categories->where('slug', 'orkideler')->first()->id,
                'delivery_days' => 2,
                'care_instructions' => 'Haftada 2-3 kez az miktarda su verin.',
            ],
            [
                'name' => 'Mor Orkide',
                'slug' => 'mor-orkide',
                'description' => 'Büyüleyici mor orkide, özel saksıda.',
                'short_description' => 'Saksıda mor orkide',
                'price' => 220.00,
                'sale_price' => 190.00,
                'stock_quantity' => 20,
                'sku' => 'POR-001',
                'is_featured' => true,
                'category_id' => $categories->where('slug', 'orkideler')->first()->id,
                'delivery_days' => 2,
            ],

            // Buketler kategorisi
            [
                'name' => 'Karışık Çiçek Buketi',
                'slug' => 'karisik-cicek-buketi',
                'description' => 'Renkli karışık çiçeklerden oluşan özel buket.',
                'short_description' => 'Karışık çiçek buketi',
                'price' => 160.00,
                'stock_quantity' => 35,
                'sku' => 'MFB-001',
                'category_id' => $categories->where('slug', 'buketler')->first()->id,
                'delivery_days' => 1,
            ],
            [
                'name' => 'Doğum Günü Buketi',
                'slug' => 'dogum-gunu-buketi',
                'description' => 'Doğum günü kutlamaları için özel tasarım buket.',
                'short_description' => 'Doğum günü özel buketi',
                'price' => 140.00,
                'sale_price' => 120.00,
                'stock_quantity' => 45,
                'sku' => 'BDB-001',
                'is_featured' => true,
                'category_id' => $categories->where('slug', 'buketler')->first()->id,
                'delivery_days' => 1,
            ],

            // Saksı Çiçekleri
            [
                'name' => 'Karanfil Saksısı',
                'slug' => 'karanfil-saksisi',
                'description' => 'Renkli karanfiller, dekoratif saksıda.',
                'short_description' => 'Saksıda karanfil',
                'price' => 80.00,
                'stock_quantity' => 60,
                'sku' => 'CAR-001',
                'category_id' => $categories->where('slug', 'saksi-cicekleri')->first()->id,
                'delivery_days' => 1,
            ],
        ];

        foreach ($products as $product) {
            \App\Models\Product::create($product);
        }
    }
}
