<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Güller',
                'slug' => 'guller',
                'description' => 'Aşkın ve sevginin simgesi güller. Kırmızı, beyaz, pembe ve sarı güller.',
                'icon' => 'bi-flower1',
                'color' => '#E91E63',
                'sort_order' => 1,
            ],
            [
                'name' => 'Orkideler',
                'slug' => 'orkideler',
                'description' => 'Zarafet ve inceliğin simgesi orkideler. Ev ve ofis dekorasyonu için ideal.',
                'icon' => 'bi-flower2',
                'color' => '#9C27B0',
                'sort_order' => 2,
            ],
            [
                'name' => 'Buketler',
                'slug' => 'buketler',
                'description' => 'Özel günler için hazırlanmış buketler. Doğum günü, yıldönümü ve özel günler için.',
                'icon' => 'bi-gift',
                'color' => '#FF9800',
                'sort_order' => 3,
            ],
            [
                'name' => 'Saksı Çiçekleri',
                'slug' => 'saksi-cicekleri',
                'description' => 'Evinizi renklendiren saksı çiçekleri. Uzun ömürlü ve bakımı kolay.',
                'icon' => 'bi-flower3',
                'color' => '#4CAF50',
                'sort_order' => 4,
            ],
            [
                'name' => 'Sevgililer Günü',
                'slug' => 'sevgililer-gunu',
                'description' => 'Sevgililer günü özel koleksiyonu. Romantik buketler ve özel tasarımlar.',
                'icon' => 'bi-heart',
                'color' => '#F44336',
                'sort_order' => 5,
            ],
            [
                'name' => 'Doğum Günü',
                'slug' => 'dogum-gunu',
                'description' => 'Doğum günü kutlamaları için özel çiçek aranjmanları.',
                'icon' => 'bi-cake',
                'color' => '#2196F3',
                'sort_order' => 6,
            ],
        ];

        foreach ($categories as $category) {
            \App\Models\Category::create($category);
        }
    }
}
