<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stories', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->text('description')->nullable();
            $table->string('image'); // Story kapak resmi
            $table->string('type')->default('product'); // product, category, custom, link
            $table->unsignedBigInteger('product_id')->nullable(); // Ürün story'si ise
            $table->unsignedBigInteger('category_id')->nullable(); // Kategori story'si ise
            $table->string('custom_link')->nullable(); // Özel link
            $table->string('background_color')->default('#FF6B6B'); // Story arkaplan rengi
            $table->string('text_color')->default('#FFFFFF'); // Metin rengi
            $table->integer('sort_order')->default(0);
            $table->boolean('is_active')->default(true);
            $table->timestamp('expires_at')->nullable(); // Story süresi
            $table->timestamps();

            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stories');
    }
};
