<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->id();
            $table->string('title'); // Slider başlığı
            $table->text('description'); // Slider açıklaması
            $table->string('image')->nullable(); // Slider resmi
            $table->string('button_text')->nullable(); // Buton metni
            $table->string('button_link')->nullable(); // Buton linki
            $table->string('background_color')->default('#E91E63'); // Arka plan rengi
            $table->string('text_color')->default('#FFFFFF'); // Metin rengi
            $table->integer('sort_order')->default(0); // Sıralama
            $table->boolean('is_active')->default(true); // Aktif/pasif
            $table->timestamps();

            $table->index(['is_active', 'sort_order']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sliders');
    }
};
