<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique(); // Sipariş numarası
            $table->unsignedBigInteger('user_id'); // Kullanıcı
            $table->string('status')->default('pending'); // pending, confirmed, shipped, delivered, cancelled
            $table->decimal('subtotal', 10, 2); // Ara toplam
            $table->decimal('tax_amount', 10, 2)->default(0); // KDV
            $table->decimal('shipping_cost', 10, 2)->default(0); // Kargo ücreti
            $table->decimal('discount_amount', 10, 2)->default(0); // İndirim
            $table->decimal('total_amount', 10, 2); // Toplam tutar

            // Teslimat bilgileri
            $table->string('delivery_name'); // Teslim alacak kişi
            $table->string('delivery_phone'); // Telefon
            $table->text('delivery_address'); // Adres
            $table->string('delivery_city'); // Şehir
            $table->string('delivery_district'); // İlçe
            $table->string('delivery_postal_code')->nullable(); // Posta kodu
            $table->date('delivery_date'); // Teslimat tarihi
            $table->string('delivery_time')->nullable(); // Teslimat saati
            $table->text('delivery_notes')->nullable(); // Teslimat notları

            // Ödeme bilgileri
            $table->string('payment_method')->default('cash'); // cash, card, transfer
            $table->string('payment_status')->default('pending'); // pending, paid, failed
            $table->timestamp('paid_at')->nullable(); // Ödeme tarihi

            $table->text('notes')->nullable(); // Sipariş notları
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->index(['user_id', 'status']);
            $table->index('order_number');
            $table->index('delivery_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
