<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Ürün adı
            $table->string('slug')->unique(); // URL dostu isim
            $table->text('description'); // Ürün açıklaması
            $table->text('short_description')->nullable(); // Kısa açıklama
            $table->decimal('price', 10, 2); // Fiyat
            $table->decimal('sale_price', 10, 2)->nullable(); // İndirimli fiyat
            $table->integer('stock_quantity')->default(0); // Stok miktarı
            $table->string('sku')->unique(); // Stok kodu
            $table->json('images')->nullable(); // Ürün resimleri (JSON array)
            $table->string('featured_image')->nullable(); // Ana resim
            $table->boolean('is_featured')->default(false); // Öne çıkan ürün
            $table->boolean('is_active')->default(true); // Aktif/pasif
            $table->string('status')->default('active'); // active, inactive, out_of_stock
            $table->json('attributes')->nullable(); // Ek özellikler (renk, boyut vb.)
            $table->decimal('weight', 8, 2)->nullable(); // Ağırlık (kargo için)
            $table->string('care_instructions')->nullable(); // Bakım talimatları
            $table->integer('delivery_days')->default(1); // Teslimat süresi (gün)
            $table->unsignedBigInteger('category_id'); // Kategori ilişkisi
            $table->timestamps();

            $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            $table->index(['is_active', 'is_featured']);
            $table->index(['category_id', 'is_active']);
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
