<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{
    /** @use HasFactory<\Database\Factories\UserFactory> */
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'phone',
        'birth_date',
        'gender',
        'address',
        'city',
        'district',
        'postal_code',
        'is_active',
        'role',
        'last_login_at'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
            'birth_date' => 'date',
            'is_active' => 'boolean',
            'last_login_at' => 'datetime',
        ];
    }

    /**
     * Kullanıcının siparişleri
     */
    public function orders()
    {
        return $this->hasMany(Order::class);
    }

    /**
     * Kullanıcının sepet öğeleri
     */
    public function cartItems()
    {
        return $this->hasMany(CartItem::class);
    }

    /**
     * Admin mi kontrol et
     */
    public function isAdmin()
    {
        return $this->role === 'admin';
    }

    /**
     * Tam adres
     */
    public function getFullAddressAttribute()
    {
        $parts = array_filter([
            $this->address,
            $this->district,
            $this->city,
            $this->postal_code
        ]);

        return implode(', ', $parts);
    }

    /**
     * Scope: Sadece aktif kullanıcılar
     */
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    /**
     * Scope: Admin kullanıcılar
     */
    public function scopeAdmins($query)
    {
        return $query->where('role', 'admin');
    }

    /**
     * Scope: Müşteri kullanıcılar
     */
    public function scopeCustomers($query)
    {
        return $query->where('role', 'customer');
    }
}
