<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;

class CategoryController extends Controller
{
    /**
     * Kategori listeleme sayfası
     */
    public function index()
    {
        $categories = Category::active()
            ->main()
            ->ordered()
            ->withCount('activeProducts')
            ->get();

        return view('categories.index', compact('categories'));
    }

    /**
     * Kategori detay sayfası ve ürünleri
     */
    public function show($categorySlug, Request $request)
    {
        $category = Category::where('slug', $categorySlug)
            ->active()
            ->firstOrFail();

        // Ürünleri çek ve filtrele
        $query = Product::active()
            ->inStock()
            ->where('category_id', $category->id)
            ->with('category');

        // Fiyat filtresi
        if ($request->filled('min_price')) {
            $query->where('price', '>=', $request->min_price);
        }

        if ($request->filled('max_price')) {
            $query->where('price', '<=', $request->max_price);
        }

        // Sıralama
        switch ($request->get('sort', 'name')) {
            case 'price_asc':
                $query->orderBy('price', 'asc');
                break;
            case 'price_desc':
                $query->orderBy('price', 'desc');
                break;
            case 'newest':
                $query->latest();
                break;
            default:
                $query->orderBy('name');
        }

        $products = $query->paginate(12)->withQueryString();

        return view('categories.show', compact('category', 'products'));
    }
}
