# Çiçek Bahçesi E-Ticaret Sitesi

Laravel tabanlı çiçek satış e-ticaret web sitesi.

## Web Hosting Kurulum Gereksinimleri

### Minimum Sistem Gereksinimleri

- **PHP**: 8.1 veya üzeri
- **Web Sunucu**: Apache 2.4+ veya Nginx 1.18+
- **Veritabanı**: MySQL 5.7+ veya MariaDB 10.3+
- **Composer**: 2.0+
- **Node.js**: 18.0+ (frontend build için)
- **NPM**: 8.0+

### Önerilen Hosting Özellikleri

- **RAM**: En az 1GB (2GB+ önerilir)
- **Disk Alanı**: En az 1GB (5GB+ önerilir)
- **SSL Sertifikası**: Let's Encrypt veya ücretli SSL
- **PHP Uzantıları**: 
  - BCMath
  - Ctype
  - cURL
  - DOM
  - Fileinfo
  - JSON
  - Mbstring
  - OpenSSL
  - PDO
  - Tokenizer
  - XML
  - GD veya Imagick (resim işleme için)

## Kurulum Talimatları

### 1. Dosyaları Sunucuya Yükleme

```bash
# Proje dosyalarını sunucuya yükleyin
# Git kullanarak:
git clone [repository-url] /path/to/your/domain

# Veya FTP/SFTP ile dosyaları yükleyin
```

### 2. Composer Bağımlılıklarını Yükleme

```bash
# Sunucuda proje dizinine gidin
cd /path/to/your/domain

# Composer bağımlılıklarını yükleyin
composer install --optimize-autoloader --no-dev
```

### 3. Environment Dosyasını Yapılandırma

```bash
# .env dosyasını oluşturun
cp .env.example .env

# Uygulama anahtarını oluşturun
php artisan key:generate
```

### 4. .env Dosyasını Düzenleme

Aşağıdaki ayarları sunucu bilgilerinize göre güncelleyin:

```env
APP_NAME="Çiçek Bahçesi"
APP_ENV=production
APP_KEY=base64:your-generated-key
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=your_database_name
DB_USERNAME=your_database_user
DB_PASSWORD=your_database_password

MAIL_MAILER=smtp
MAIL_HOST=your-smtp-host
MAIL_PORT=587
MAIL_USERNAME=your-email@domain.com
MAIL_PASSWORD=your-email-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@yourdomain.com
MAIL_FROM_NAME="${APP_NAME}"

# PayTR Ödeme Ayarları
PAYTR_MERCHANT_ID=your_merchant_id
PAYTR_MERCHANT_KEY=your_merchant_key
PAYTR_MERCHANT_SALT=your_merchant_salt
PAYTR_TEST_MODE=false
```

### 5. Veritabanı Kurulumu

```bash
# Veritabanı migrationlarını çalıştırın
php artisan migrate --force

# Örnek verileri yükleyin (isteğe bağlı)
php artisan db:seed --force
```

### 6. Frontend Assetlerini Build Etme

```bash
# NPM bağımlılıklarını yükleyin
npm install

# Production için assetleri build edin
npm run build
```

### 7. Dosya İzinlerini Ayarlama

```bash
# Storage ve cache dizinlerine yazma izni verin
chmod -R 775 storage
chmod -R 775 bootstrap/cache

# Web sunucusu kullanıcısına sahiplik verin
chown -R www-data:www-data storage bootstrap/cache
```

### 8. Web Sunucu Yapılandırması

#### Apache (.htaccess)

Proje kök dizininde `.htaccess` dosyası mevcut olmalı:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

#### Nginx

```nginx
server {
    listen 80;
    server_name yourdomain.com www.yourdomain.com;
    root /path/to/your/domain/public;

    add_header X-Frame-Options "SAMEORIGIN";
    add_header X-Content-Type-Options "nosniff";

    index index.php;

    charset utf-8;

    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }

    location = /favicon.ico { access_log off; log_not_found off; }
    location = /robots.txt  { access_log off; log_not_found off; }

    error_page 404 /index.php;

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_param SCRIPT_FILENAME $realpath_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location ~ /\.(?!well-known).* {
        deny all;
    }
}
```

### 9. SSL Sertifikası Kurulumu

```bash
# Let's Encrypt ile SSL kurulumu (Certbot kullanarak)
sudo certbot --apache -d yourdomain.com -d www.yourdomain.com

# Veya hosting sağlayıcınızın SSL panelinden aktifleştirin
```

### 10. Cron Job Kurulumu

Laravel scheduler için cron job ekleyin:

```bash
# Crontab'ı düzenleyin
crontab -e

# Aşağıdaki satırı ekleyin
* * * * * cd /path/to/your/domain && php artisan schedule:run >> /dev/null 2>&1
```

### 11. Cache Optimizasyonu

```bash
# Production için cache'leri optimize edin
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Güvenlik Kontrolleri

### 1. Dosya İzinleri
```bash
# Hassas dosyaların izinlerini kontrol edin
chmod 600 .env
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

### 2. .env Dosyası Güvenliği
- `.env` dosyasının web erişimine açık olmadığından emin olun
- Veritabanı şifrelerini güçlü yapın
- APP_DEBUG=false olarak ayarlayın

### 3. Veritabanı Güvenliği
- Güçlü veritabanı şifreleri kullanın
- Veritabanı kullanıcısına sadece gerekli izinleri verin

## Performans Optimizasyonu

### 1. OPcache Aktifleştirme
```ini
; php.ini dosyasında
opcache.enable=1
opcache.memory_consumption=128
opcache.max_accelerated_files=4000
opcache.revalidate_freq=60
```

### 2. Redis Cache (Opsiyonel)
```env
CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=redis
```

## Sorun Giderme

### Yaygın Hatalar

1. **500 Internal Server Error**
   - Dosya izinlerini kontrol edin
   - Laravel log dosyalarını inceleyin: `storage/logs/laravel.log`

2. **Veritabanı Bağlantı Hatası**
   - .env dosyasındaki veritabanı bilgilerini kontrol edin
   - Veritabanı sunucusunun çalıştığından emin olun

3. **Asset Dosyaları Yüklenmiyor**
   - `npm run build` komutunu çalıştırın
   - `public/build` dizininin var olduğundan emin olun

### Log Dosyaları
```bash
# Laravel loglarını görüntüleyin
tail -f storage/logs/laravel.log

# Web sunucu loglarını kontrol edin
tail -f /var/log/apache2/error.log
# veya
tail -f /var/log/nginx/error.log
```

## Hosting Sağlayıcı Önerileri

### Türkiye'deki Popüler Hosting Sağlayıcıları

1. **Turhost** - Laravel desteği mevcut
2. **Natro** - PHP 8.1+ desteği
3. **Hostinger** - Uygun fiyatlı
4. **DigitalOcean** - VPS seçeneği
5. **AWS** - Ölçeklenebilir çözüm

### VPS Kurulumu İçin

Eğer VPS kullanıyorsanız, aşağıdaki adımları da takip edin:

```bash
# Ubuntu/Debian için
sudo apt update
sudo apt install nginx mysql-server php8.1-fpm php8.1-mysql php8.1-mbstring php8.1-xml php8.1-gd php8.1-curl php8.1-zip php8.1-bcmath php8.1-tokenizer

# Composer kurulumu
curl -sS https://getcomposer.org/installer | php
sudo mv composer.phar /usr/local/bin/composer

# Node.js kurulumu
curl -fsSL https://deb.nodesource.com/setup_18.x | sudo -E bash -
sudo apt-get install -y nodejs
```

## İletişim ve Destek

Kurulum sırasında sorun yaşarsanız:

1. Laravel dokümantasyonunu kontrol edin: https://laravel.com/docs
2. Hosting sağlayıcınızın destek ekibiyle iletişime geçin
3. Proje GitHub repository'sinde issue açın

---

**Not**: Bu kurulum talimatları genel bir rehberdir. Hosting sağlayıcınızın özel gereksinimleri olabilir. Kurulum öncesi hosting sağlayıcınızla iletişime geçmenizi öneririz.